//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Mostrar el ejemplo 1
// Fecha:    M.22.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de las bases
int N=3;

// Altura
real Altura=0.8;

// El ápice de la pirámide
triple Apice=(0,0,Altura);

// Las bases
path3 PoligonoBase1 = path3(rotate(30)*polygon(N));
path3 PoligonoBase2 = shift(Altura*Z)*PoligonoBase1;

// Las caras de la pirámide
path3[] Caras={PoligonoBase1};
for (int i=0; i<N; ++i)
    {
    Caras.push(point(PoligonoBase1,i)--point(PoligonoBase1,i+1)--Apice--cycle);
    }

// Dibujamos las caras de la pirámide
draw(surface(Caras),red+opacity(.7));

// Dibujamos las aristas de la pirámide
draw(Caras,1.5bp+red);

// Las caras del prisma
path3[] Caras={PoligonoBase1, PoligonoBase2};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase1,i)--point(PoligonoBase1,i+1)--
      point(PoligonoBase2,i+1)--point(PoligonoBase2,i)--cycle); }

// Dibujamos las caras del prisma
draw(surface(Caras),lightgray+opacity(.4));

// Dibujamos las aristas del prisma
draw(Caras,1bp+black);
