//---------------------------------------------------------------
// Fichero:  ejemplo4.asy
// Objetivo: Mostrar el ejemplo 4
// Fecha:    D.20.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.4cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de la base
int N=5;

// La base es un polígono regular
path3 PoligonoBase = path3(rotate(5)*polygon(N));

// El vértice superior
triple V=(0,0,2);

// Las caras del poliedro
path3[] Caras={PoligonoBase};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--V--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);
