//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Representar el desarrollo plano del prisma
// Fecha:    X.16.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Un pentágono regular
path Pentagono=polygon(5);

// El lado del pentágono
real Lado=length(point(Pentagono,0)-point(Pentagono,1));

// La altura del prisma
real Altura=0.8;

// La apotema de pentágono
real Apotema=length(
    (point(Pentagono,0)+point(Pentagono,1))/2-(0,0));

// Las caras laterales
for (int i=0 ; i<5 ; ++i)
    {
    draw(box((i*Lado,0),((i+1)*Lado,Altura)));
    label("Cara",((i+0.5)*Lado,(2/3)*Altura),fontsize(8pt));
    label("lateral",((i+0.5)*Lado,(1/3)*Altura),fontsize(8pt));
    }

// Las bases
draw(shift(1.5*Lado,Apotema+Altura)*Pentagono);
label("Base",(1.5*Lado,Apotema+Altura),fontsize(12pt));
draw(shift(3.5*Lado,-Altura)*rotate(180)*Pentagono);
label("Base",(3.5*Lado,-Altura),fontsize(12pt));
