//---------------------------------------------------------------
// Fichero:  cubovol2.asy
// Objetivo: Mostrar el volumen de un cubo, segunda parte
// Fecha:    X.16.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(5cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// ---------------------------------------------------------------------------
// Copyright (c) 2008, Jens Schwaiger
// Institut fuer Mathematik, Karl-Franzens-Universitaet
// Heinrichstrasse 36, A-8010 GRAZ, Austria
// Homepage: http://www-ang.kfunigraz.ac.at/~schwaige/

// Version: $Id: polyhedron.asy,v 0.0 2008/02/03 Jens Schwaiger Exp $

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.

// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

// Modified by Philippe Ivaldi

path3[] cube;
cube[0]=(-0.5,-0.5,0)--(0.5,-0.5,0)--(0.5,0.5,0)--(-0.5,0.5,0)--cycle;
cube[1]=(-0.5,-0.5,0)--(0.5,-0.5,0)--(0.5,-0.5,1)--(-0.5,-0.5,1)--cycle;
cube[2]=(0.5,-0.5,0)--(0.5,0.5,0)--(0.5,0.5,1)--(0.5,-0.5,1)--cycle;
cube[3]=(0.5,0.5,0)--(-0.5,0.5,0)--(-0.5,0.5,1)--(0.5,0.5,1)--cycle;
cube[4]=(-0.5,0.5,0)--(-0.5,-0.5,0)--(-0.5,-0.5,1)--(-0.5,0.5,1)--cycle;
cube[5]=(-0.5,-0.5,1)--(0.5,-0.5,1)--(0.5,0.5,1)--(-0.5,0.5,1)--cycle;
cube=shift(-0.5Z)*cube;
cube=scale3(1/abs(point(cube[0],0)))*cube;
// ---------------------------------------------------------------------------

// Reducimos el cubo
path3[] cubito=scale3(0.5)*cube;

// El lado del cubo pequeño
real lado=length(point(cubito[0],0)-point(cubito[0],1));

// Repetimos 8 veces el cubo pequeño
for (int i=0; i<2 ; ++i) {
for (int j=0; j<2 ; ++j) {
for (int k=0; k<2 ; ++k) {
    // El cubo
    draw(shift(scale3(lado)*(i,j,k))*surface(cubito),lightblue+opacity(.5));
    // Las aristas
    draw(shift(scale3(lado)*(i,j,k))*cubito,1bp+blue);
    }}}
