//---------------------------------------------------------------
// Fichero:  cubo.asy
// Objetivo: Mostrar un cubo
// Fecha:    X.16.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(5cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// ---------------------------------------------------------------------------
// Copyright (c) 2008, Jens Schwaiger
// Institut fuer Mathematik, Karl-Franzens-Universitaet
// Heinrichstrasse 36, A-8010 GRAZ, Austria
// Homepage: http://www-ang.kfunigraz.ac.at/~schwaige/

// Version: $Id: polyhedron.asy,v 0.0 2008/02/03 Jens Schwaiger Exp $

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.

// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

// Modified by Philippe Ivaldi

path3[] cube;
cube[0]=(-0.5,-0.5,0)--(0.5,-0.5,0)--(0.5,0.5,0)--(-0.5,0.5,0)--cycle;
cube[1]=(-0.5,-0.5,0)--(0.5,-0.5,0)--(0.5,-0.5,1)--(-0.5,-0.5,1)--cycle;
cube[2]=(0.5,-0.5,0)--(0.5,0.5,0)--(0.5,0.5,1)--(0.5,-0.5,1)--cycle;
cube[3]=(0.5,0.5,0)--(-0.5,0.5,0)--(-0.5,0.5,1)--(0.5,0.5,1)--cycle;
cube[4]=(-0.5,0.5,0)--(-0.5,-0.5,0)--(-0.5,-0.5,1)--(-0.5,0.5,1)--cycle;
cube[5]=(-0.5,-0.5,1)--(0.5,-0.5,1)--(0.5,0.5,1)--(-0.5,0.5,1)--cycle;
cube=shift(-0.5Z)*cube;
cube=scale3(1/abs(point(cube[0],0)))*cube;
// ---------------------------------------------------------------------------

// Dibujamos las caras
draw(surface(cube),lightgray+opacity(.7));

// Dibujamos las aristas
draw(cube,1.5bp+black);

// Dividimos cada cara en cuatro partes
for (int i=0 ; i<6 ; ++i)
    {
    triple A=point(cube[i],0);
    triple B=point(cube[i],1);
    triple C=point(cube[i],2);
    triple D=point(cube[i],3);
    draw((A+B)/2--(C+D)/2,1bp+blue);
    draw((A+D)/2--(B+C)/2,1bp+blue);
    }
