//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Mostrar el ejemplo
// Fecha:    V.11.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(10cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// La base es un cuadrilátero
triple A=(0,0,0), B=(1,0,0), C=(1,1,0), D=(0,2,0);

// El techo es un triángulo
triple E1=(0,0,0.8), F=(1,1,1), G=(0,2,0.8);

// Las caras del poliedro
path3[] Caras={A--B--C--D--cycle,
               A--B--E1--cycle,
               B--C--F--cycle,
               E1--B--F--cycle,
               E1--G--F--cycle,
               E1--A--D--G--cycle,
               D--C--F--G--cycle,
               };

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// Dibujamos una diagonal
draw(B--G,2bp+red);

// Nombramos los vértices
label("A",A,S);
label("B",B,W);
label("C",C,S);
label("D",D,E);
label("E",E1,N);
label("F",F,NE);
label("G",G,NE);
