//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Mostrar el enunciado 2
// Fecha:    L.21.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Textos en Unicode
import unicode;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 8, Ymin = 0, Ymax = 9, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicksX = Ticks(Step=1, NoZero, Size=0.5mm, pTick=black);
ticks FormatoTicksY = Ticks(Step=1, NoZero, Size=0.5mm, pTick=black);

// Formato de texto de los dos ejes
pen FormatoTexto = black+fontsize(10pt);

// El eje de ordenadas
yaxis("Núm. de vértices de la pirámide",
      ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Núm. de lados de cada base",
      xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
