//---------------------------------------------------------------
// Fichero:  poligono.asy
// Objetivo: Representar el polígono de frecuencias
// Fecha:    L.2.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,8cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(10pt);

// Los valores
string Valor[]={'1', '2', '3', '4', '5', '6', '7', '8', '9', '10'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={6, 18, 24, 44, 48, 54, 68, 76, 94, 100};
int MaxFre=max(Frecuencia);

// Escalas para modificar las frecuencias
real EscalaY=1;
real EscalaX=10;

// Los ejes
draw((0,0)--(EscalaX*(TotalVal+.5),0));
draw((0,0)--(0,EscalaY*(MaxFre+.5)));

// Líneas horizontales
for ( int i=10 ; i<=100 ; i+=10 )
    { draw((0.1,EscalaY*i)--(EscalaX*10.5,EscalaY*i),gray+0.75bp); }

// El eje de ordenadas
for ( int i=0 ; i<=100 ; i+=10 )
    {
    label(string(i)+'\ \%', (0,EscalaY*i), 2*W, Formato);
    draw((-0.1,EscalaY*i)--(0.1,EscalaY*i));
    }

// El eje de absisas, los puntos y la línea
path Linea;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (EscalaX*(i+1),0), 1.5*S, Formato);
    draw((EscalaX*(i+1),-0.2)--(EscalaX*(i+1),0.2));
    pair Punto=(EscalaX*(i+1),EscalaY*Frecuencia[i]);
    dot(Punto,3bp+black);
    Linea=Linea--Punto;
    }
draw(Linea,1bp+blue);
