//---------------------------------------------------------------
// Fichero:  ejemplo5.asy
// Objetivo: Representar el ejemplo 5
// Fecha:    X.27.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Caracteres Unicode
include unicode;

// Tamaño de la imagen
size(8.8cm,4.5cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(7pt);

// Los valores
string Valor[]={'Blanco', 'Negro', 'Azul', 'Rojo',
                'Amarillo', 'Verde', 'Marrón'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={28, 21, 35, 32, 15, 38, 9};
int MaxFre=max(Frecuencia);

// Grosor de las barras
real Grosor=0.6;

// Escala para modificar las frecuencias
real EscalaY=0.25;
real EscalaX=3;

// Los ejes
draw((0,0)--(EscalaX*(TotalVal+.5),0));
draw((0,0)--(0,EscalaY*40.5));

// Líneas horizontales
for ( int i=10 ; i<=40 ; i+=10 )
    { draw((EscalaX*0.1,EscalaY*i)--(EscalaX*7.5,EscalaY*i),gray+0.75bp); }

// El eje de ordenadas
for ( int i=10 ; i<=40 ; i+=10 )
    {
    label(string(i), (0,EscalaY*i), 2*W, Formato);
    draw((-0.1,EscalaY*i)--(0.1,EscalaY*i));
    }

// El eje de absisas y las barras
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (EscalaX*(i+1),0), 1.5*S, Formato);
    filldraw(box((EscalaX*(i+1-Grosor/2),0),
                 (EscalaX*(i+1+Grosor/2),EscalaY*Frecuencia[i])),white);
    }
