//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar el ejemplo 2
// Fecha:    X.27.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm,4.5cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(8pt);

// Los valores
string Valor[]={'0', '1', '2', '3', '4', '5', '6'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={12, 9, 18, 24, 21, 13, 5};
int MaxFre=max(Frecuencia);

// Grosor de las barras
real Grosor=0.6;

// Escala para modificar las frecuencias
real Escala=0.25;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*25.5));

// Líneas horizontales
for ( int i=5 ; i<=25 ; i+=5 )
    { draw((0.1,Escala*i)--(7.5,Escala*i),gray+0.75bp); }

// El eje de ordenadas
for ( int i=5 ; i<=25 ; i+=5 )
    {
    label(string(i), (0,Escala*i), 2*W, Formato);
    draw((-0.1,Escala*i)--(0.1,Escala*i));
    }

// El eje de absisas y las barras
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, Formato);
    filldraw(box((i+1-Grosor/2,0),(i+1+Grosor/2,Escala*Frecuencia[i])),white);
    draw((i+1,-0.05)--(i+1,0.05));
    }
