//---------------------------------------------------------------
// Fichero:  barras.asy
// Objetivo: Representar un diagrama de barras
// Fecha:    S.23.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
string Valor[]={'A', 'B', 'C', 'D'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={2, 4, 3, 5};
int MaxFre=max(Frecuencia);

// Grosor de las barras
real Grosor=0.25;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,MaxFre+.5));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    {
    label(string(i), (0,i), W);
    draw((-0.1,i)--(0.1,i));
    }

// El eje de absisas y las barras
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), S);
    draw((i+1,-0.05)--(i+1,0.05));
    draw(box((i+1-Grosor/2,0),(i+1+Grosor/2,Frecuencia[i])));
    }
