//---------------------------------------------------------------
// Fichero:  enunciado2b.asy
// Objetivo: Representar el esquema para la solución 2
// Fecha:    J.5.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen FormatoX=black+fontsize(12pt);
pen FormatoY=black+fontsize(8pt);

// Los valores
string Valor[]={'A', 'B', 'C', 'D'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={25, 40, 85, 100};
int MaxFre=max(Frecuencia);

// Escalas para modificar las frecuencias
real EscalaY=1;
real EscalaX=20;

// Los ejes
draw((0,0)--(EscalaX*(TotalVal+.5),0));
draw((0,0)--(0,EscalaY*(MaxFre+.5)));

// Líneas horizontales
for ( int i=5 ; i<=100 ; i+=5 )
    { draw((0.1,EscalaY*i)--(EscalaX*4.5,EscalaY*i),gray+0.75bp); }

// Líneas verticales
for ( int i=1 ; i<=4 ; ++i )
    { draw((EscalaX*i,0.1)--(EscalaX*i,EscalaY*100.5),gray+0.75bp); }

// El eje de ordenadas
for ( int i=0 ; i<=100 ; i+=5 )
    {
    label(string(i)+'\ \%', (0,EscalaY*i), 2*W, FormatoY);
    draw((-0.1,EscalaY*i)--(0.1,EscalaY*i));
    }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (EscalaX*(i+1),0), 1.5*S, FormatoX);
    draw((EscalaX*(i+1),-0.2)--(EscalaX*(i+1),0.2));
    }
