//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Representar el enunciado 2
// Fecha:    X.4.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
string Valor[]={'A', 'B', 'C', 'D'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={25, 15, 45, 15};
int MaxFre=max(Frecuencia);

// La constante de proporcionalidad
real k=360/sum(Frecuencia);

// El círculo
draw(unitcircle);

// Los sectores
real Angulo=0;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    real Avance=k*Frecuencia[i];
    draw((0,0)--dir(Angulo));
    draw((0,0)--dir(Angulo+Avance));
    label(Valor[i],0.6*dir(Angulo+Avance/2),fontsize(18pt));
    Angulo += Avance;
    }

// Los ángulos
markangle("$\alpha$", radius=10mm, dir(90), (0,0), dir(144), 1bp+blue);
markangle("$\alpha$", radius=10mm, dir(-54), (0,0), dir(0), 1bp+blue);
markangle("$3\alpha$", radius=6mm, dir(144), (0,0), dir(-54), 1bp+blue);
markrightangle(dir(0), (0,0), dir(90), 6mm, 1bp+blue);
