//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Representar la solución 4
// Fecha:    D.1.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.2cm,5.8cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(8pt);

// Los valores
string Valor[]={'0', '1', '2', '3', '4', '5', '6', '7'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={8, 7, 12, 9, 5, 14, 10, 15};
int MaxFre=max(Frecuencia);

// Escalas para modificar las frecuencias
real EscalaY=1;
real EscalaX=2.5;

// Los ejes
draw((0,0)--(EscalaX*(TotalVal+.5),0));
draw((0,0)--(0,EscalaY*(MaxFre+.5)));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    {
    label(string(i), (0,EscalaY*i), 2*W, Formato);
    draw((-0.1,EscalaY*i)--(0.1,EscalaY*i));
    }

// El eje de absisas, los puntos y la línea
path Linea;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (EscalaX*(i+1),0), 1.5*S, Formato);
    draw((EscalaX*(i+1),-0.05)--(EscalaX*(i+1),0.05));
    pair Punto=(EscalaX*(i+1),EscalaY*Frecuencia[i]);
    dot(Punto,2bp+black);
    Linea=Linea--Punto;
    }
draw(Linea);
