#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  producto.py
# Objetivo: Da el producto de un número por un valor en sexagesimal
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    L.19.7.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los números de la línea de órdenes

# El factor
Factor = int(sys.argv[1])

# La expresion sexagesimal tiene el formato h.m.s
Sexagesimal = sys.argv[2]
partesSex = Sexagesimal.split('.')

# Los datos individuales
HorSex = int(partesSex[0])
MinSex = int(partesSex[1])
SegSex = int(partesSex[2])

# Multimplicamos
Hor = Factor * HorSex
Min = Factor * MinSex
Seg = Factor * SegSex

# Corregimos los segundos
if Seg>59:
    MinTmp, SegTmp = divmod(Seg,60)
    Min += MinTmp
    Seg = SegTmp

# Corregimos los minutos
if Min>59:
    HorTmp, MinTmp = divmod(Min,60)
    Hor += HorTmp
    Min = MinTmp

# Imprimimos el resultado
print str(Hor) + '.' + str(Min) + '.' + str(Seg)
