//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Representar el enunciado 2
// Fecha:    L.26.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta a partir de una cadena
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Puntos de la circunferencia
pair V1=PuntoCir(150), V2=PuntoCir(240),
     A=PuntoCir(83.71), B=PuntoCir(0), C=PuntoCir(-63.51);

// El centro de la circunferencia
pair T=(0,0);
dot(T,4bp+black);

// Los ángulos
markangle(Eti("$\alpha$"), radius=5mm, C, V2, B, 0.5bp+blue);

// La circunferencia
draw(circle(T,1));

// Los lados de los ańgulos
draw(A -- V1 -- B);
draw(B -- V2 -- C);
draw(A -- T -- C);

// Los nombres
label(Eti("T"), T, W);
label(Eti("A"), A, N);
label(Eti("B"), B, E);
label(Eti("C"), C, SE);
label(Eti("D"), V2, SW);
label(Eti("E"), V1, W);
