//---------------------------------------------------------------
// Fichero:  enunciado11.asy
// Objetivo: Representar el enunciado 11
// Fecha:    S.24.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta a partir de una cadena
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Función que devuelve como cadena el valor en
// grados, minutos y segundos (redondeados) de un ángulo en grados
string GMS(real Ang)
    {
    int Gra = Floor(Ang);
    Ang = 60*(Ang - Gra);
    int Min = Floor(Ang);
    int Seg = round(60*(Ang - Min));
    string Respuesta = string(Gra)+"$^\circ$\,";
    Respuesta += string(Min)+"$^\prime$\,";
    Respuesta += string(Seg)+"$^{\prime\prime}$";
    return Respuesta;
    }

// Función que devuelve como etiqueta el valor de un ángulo
Label Ang(pair P1, pair V, pair P2, int e)
    { return Eti(GMS(degrees(P2-V)-degrees(P1-V)+360*e)); }

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Puntos de la circunferencia
pair V=PuntoCir(45), A=PuntoCir(119.73), B=PuntoCir(-33.45);

// El centro de la circunferencia
pair T=(0,0);
dot(T,4bp+black);

// Los ángulos
markangle(Ang(A,V,B,0), radius=4mm, A, V, B, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, A, T, B, 0.5bp+blue);

// La circunferencia
draw(circle(T,1));

// Los lados de los ańgulos
draw(A -- V -- B);
draw(A -- T -- B);
