//---------------------------------------------------------------
// Fichero:  enunciado09.asy
// Objetivo: Representar el enunciado 9
// Fecha:    S.24.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Regular=polygon(7);
guide Camino;
for (int i=0; i<7; ++i)
    { Camino = Camino -- point(Regular,i); }
path Poligono=Camino -- cycle;

// Definición de los vértices
pair V[];
for (int i=0; i<length(Poligono); ++i)
    { V[i] = point(Poligono,i); }
V.cyclic=true;

// Los ángulos
for (int i=0; i<V.length; ++i)
    { markangle("$\alpha$", radius=4mm, V[i+1], V[i], V[i-1], 0.5bp+blue); }

// El polígono
draw(Poligono);
