//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar el ejemplo 2
// Fecha:    S.11.12.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca el 100%
draw(box((0,0),(5,3)));

// El rectángulo que marca el total
draw(box((0,0), (8,3)));

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas
draw((0,-Separacion) -- (5,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,3+Separacion) -- (8,3+Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las etiquetas
label("340", (4,3+3*Separacion), fontsize(16pt));
label("80 \%", (2.5,1.5), fontsize(16pt));
label("20 \%", (6.5,1.5), fontsize(16pt));
label("¿?", (2.5,-3*Separacion), fontsize(16pt));
