//---------------------------------------------------------------
// Fichero:  huerta.asy
// Objetivo: Representar la huerta del enunciado
// Fecha:    V.10.9.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca la fracción secundaria
fill(box((3,1.8),(7,3)), palered);

// El rectángulo que marca la fracción principal
fill(box((0,0),(3,3)), mediumgray);

// El rectángulo que marca el total
draw(box((0,0),(7,3)));

// La línea vertical
draw((3,0) -- (3,3));

// La línea horizontal
pen Punteado = linetype(new real[] {2,2});
draw((3,1.8) -- (7,1.8), Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las fracciones
draw((7+Separacion,1.8) -- (7+Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (3,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Los textos
label("Tomates", (1.5,1.5), fontsize(10pt));
label("Lechugas", (5,2.3), fontsize(10pt));
label("$\frac{3}{8}$", (1.5,-2*Separacion), fontsize(8pt));
label("$\frac{2}{5}$", (7+2*Separacion,2.3), fontsize(8pt));
label("Parte libre", (5,0.9), fontsize(10pt));
