//---------------------------------------------------------------
// Fichero:  fraccionyfraccion.asy
// Objetivo: Representar una fracción y una fracción del resto
// Fecha:    V.10.9.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca la fracción secundaria
fill(box((3,1.8),(7,3)), palered);

// El rectángulo que marca la fracción principal
fill(box((0,0),(3,3)), mediumgray);

// El rectángulo que marca el total
draw(box((0,0),(7,3)));

// La línea vertical
draw((3,0) -- (3,3));

// La línea horizontal
pen Punteado = linetype(new real[] {2,2});
draw((3,1.8) -- (7,1.8), Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las fracciones
draw((7+Separacion,1.8) -- (7+Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (3,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las fracciones
label("Fracción del total", (1.5,-2*Separacion), fontsize(6pt));

label("Fracción", (7+4*Separacion,2.6), fontsize(6pt));
label("del", (7+4*Separacion,2.3), fontsize(6pt));
label("resto", (7+4*Separacion,2), fontsize(6pt));

label("¿Fracción", (5,1.2), fontsize(8pt));
label("respecto", (5,0.9), fontsize(8pt));
label("al total?", (5,0.6), fontsize(8pt));
