//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Mostrar la solución 1
// Fecha:    X.9.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 16, Ymin = 0, Ymax = 4, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicksX = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);
ticks FormatoTicksY = Ticks(Step=0.5, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis("Dinero (eur)", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Masa (kg)", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
dot((4,1), 5pt+black);
dot((6,1.5), 5pt+black);
dot((8,2), 5pt+black);
dot((10,2.5), 5pt+black);
dot((12,3), 5pt+black);
dot((14,3.5), 5pt+black);
dot((16,4), 5pt+black);
