//---------------------------------------------------------------
// Fichero:  paso1.asy
// Objetivo: Representar el paso 1
// Fecha:    D.9.1.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.9cm);

// Grosor de las líneas
defaultpen(1);

// Los coeficientes de los factores
int Factor1[] = {-3, 7, -1, -5, 2};
int Factor2[] = {4, 1, 6, -2, 3};

// Los grados de los factores
int G1 = Factor1.length;
int G2 = Factor2.length;

// La separación entre dos cuadrados
real Sep=sqrt(2);

// Función que devuelve un punto del plano según los grados
pair Punto(int i, int j)
    {
    real X, Y;
    X=4-(i+j)/2;
    Y=2-(i-j)/2;
    return (Sep*X,Sep*Y);
    }

// Función que devuelve el texto de una potencia dado el grado
string Pot(int g)
    {
    string Respuesta;
    if ( g==0 )  { Respuesta = '1'; }
    if ( g==1 )  { Respuesta = 'x'; }
    if ( g>1 )   { Respuesta = 'x$^'+string(g)+'$'; }
    return (Respuesta);
    }

// Formato de los textos
pen ForGen=Helvetica(series="m",shape="n")+fontsize(3mm);
pen ForPot=Helvetica(series="m",shape="n")+fontsize(3mm)+blue;
pen ForSol=Helvetica(series="m",shape="n")+fontsize(2.5mm);

// Los nombres de los polinomios
label('A(x)', (-1.3,7.3), ForGen);
label('B(x)', (6.7,7.3), ForGen);

// El cuadrado básico
path Cuadrado = rotate(45)*box((0,0),(1,1));

// La cuadrícula con los productos
for ( int i=0 ; i<G1 ; ++i )
    {
    for ( int j=0 ; j<G2 ; ++j )
        {
        pair Pos=Punto(i,j);
        draw(shift(Pos)*Cuadrado,1bp+gray);
        }
    }

// El primer factor
for ( int i=0 ; i<G1 ; ++i )
    {
    // La potencia
    pair Pos=Punto(i,G1+1);
    draw(shift(Pos)*Cuadrado);
    label(Pot(i),Pos+(0,Sep/2),ForPot);

    // El coeficiente
    pair Pos=Punto(i,G1);
    draw(shift(Pos)*Cuadrado);
    label(string(Factor1[i]),Pos+(0,Sep/2),ForGen);
    }

// El segundo factor
for ( int j=0 ; j<G2 ; ++j )
    {
    // La potencia
    pair Pos=Punto(-2,j);
    draw(shift(Pos)*Cuadrado);
    label(Pot(j),Pos+(0,Sep/2),ForPot);

    // El coeficiente
    pair Pos=Punto(-1,j);
    draw(shift(Pos)*Cuadrado);
    label(string(Factor2[j]),Pos+(0,Sep/2),ForGen);
    }

