//---------------------------------------------------------------
// Fichero:  obtusangulo.asy
// Objetivo: Representar un triángulo obtusángulo con base y altura
// Fecha:    J.13.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(shift(-2,0)*grid(8,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(-2,3);

// El punto proyección
pair Q=(-2,0);

// Marcamos el ángulo recto
markrightangle(B, Q, C, 3mm, deepblue);

// La altura
draw(C -- Q);

// El triangulo
draw(A -- B -- C -- cycle);

// La prolongación de un lado
pen Punteado = linetype(new real[] {2,2});
draw(A -- Q, Punteado);

// Los puntos
dot("A", A, S, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, W, 3bp+black);
dot("Q", Q, W, 3bp+black);

// Los datos
label("6", (A+B)/2, S);
label("3", (C+Q)/2, W);
