//---------------------------------------------------------------
// Fichero:  acutangulo3.asy
// Objetivo: Paso 3 del triángulo acutángulo
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(shift(1,0)*grid(4,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(1,3), D=(5,3);

// Los puntos proyección
pair Q=(1,0), R=(5,0);

// El rectángulo
draw(C -- Q -- R -- D -- cycle);

// Los puntos
dot("C", C, W, 3bp+black);
dot("D", D, E, 3bp+black);
dot("Q", Q, W, 3bp+black);
dot("R", R, E, 3bp+black);

// La numeración
int k=1;
for ( int i=2 ; i>=0 ; i=i-1 )
    {
    for ( int j=0 ; j<4 ; ++j, ++k )
        { label(Label(string(k), fontsize(8pt)+blue), (j+1.5,i+0.5)); }
    }
