//---------------------------------------------------------------
// Fichero:  nombres.asy
// Objetivo: Poner nombres a los elementos del área
// Fecha:    X.12.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(1,3);

// El punto de la base que define la altura
pair Q=(1,0);

// El ángulo
markrightangle(B, Q, C, 3mm, 1bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// La altura
draw(C -- Q);

// Los nombres
label("A", A, W);
label("C", C, N);
label("F", B, E);
dot("Q", Q, SW, 3bp+black);
label("Base (b)", (A+B)/2, S);
label(Label(rotate(90)*"Altura (h)", fontsize(9pt)), (C+Q)/2, E);
