//---------------------------------------------------------------
// Fichero:  obtusangulo.asy
// Objetivo: Representar un triángulo obtusángulo
// Fecha:    M.11.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=rotate(10)*(0,0.6);

// El valor de a en un triángulo rectángulo
transform t=shift(0.03*(3,5));
pair B1=t*B, C1=t*(0,0.6);
draw(B1 -- C1, heavyblue);
label("$a$", (B1+C1)/2, N, heavyblue);
dot(B1, 2.5bp+heavyblue);
dot(C1, 2.5bp+heavyblue);

// La marca del ángulo
markangle("$\alpha>90^\circ$", radius=3mm, B, A, C, 0.5bp+black);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("$a_g$", (B+C)/2, N);
label("$b$", (A+C)/2, W);
label("$c$", (A+B)/2, S);
