//---------------------------------------------------------------
// Fichero:  problema2-b.asy
// Objetivo: Segundo dibujo del problema 2
// Fecha:    L.10.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(100,0), D=(0,70);

// Marcamos el ángulo recto
markrightangle(B, A, D, 2mm, gray);

// El triángulo
draw(A -- B -- D -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("D", D, W, 3bp+black);

// Los textos
label("1", (A+B)/2, S);
label("0,7", (A+D)/2, W);
label("$x$", (B+D)/2, NE);
