//---------------------------------------------------------------
// Fichero:  problema1-b.asy
// Objetivo: Segundo dibujo del problema 1
// Fecha:    L.10.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair M=(12,0), B=(24,0), C=(12,5);

// El punto medio de la base
pair M=(12,0);

// Marcamos el ángulo recto
markrightangle(B, M, C, 2mm, gray);

// El triangulo
draw(M -- B -- C -- cycle);

// Los puntos
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("M", M, W, 3bp+black);

// Los textos
label("13", (C+B)/2, NE);
label("12", (M+B)/2, S);
label("h", (C+M)/2, E);
