//---------------------------------------------------------------
// Fichero:  euler.asy
// Objetivo: Representar la recta de Euler
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,1), C=(2,5);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Los puntos medios
pair MBC=(B+C)/2;
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;

// Las proyecciones
pair QBC=intersectionpoint(B -- C, A -- A-2*Perpendicular(B,C));
pair QAB=intersectionpoint(A -- B, C -- C-2*Perpendicular(A,B));
pair QAC=intersectionpoint(A -- C, B -- B+2*Perpendicular(A,C));

// Las mediatrices
pair U1=MAB+0.4*Perpendicular(A,B);
pair U2=MAB-0.1*Perpendicular(A,B);
pair V1=MAC+0.1*Perpendicular(A,C);
pair V2=MAC-0.7*Perpendicular(A,C);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);

// El baricentro
pair G=intersectionpoint(A -- MBC, B -- MAC);
dot(Label("G", fontsize(10pt)+blue), G, NE, 4bp+blue);

// El circuncentro
pair T=intersectionpoint(U1 -- U2, V1 -- V2);
dot(Label("T", fontsize(10pt)+blue), T, E, 4bp+blue);

// El ortocentro
pair H=extension(B, QAC, A, QBC);
dot(Label("H", fontsize(10pt)+blue), H, NE, 4bp+blue);

// La recta de Euler
pair E1=G+1.75*(H-T);
pair E2=T+1.35*(G-H);
draw(E1 -- E2, 1bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);
