//---------------------------------------------------------------
// Fichero:  circuncentro.asy
// Objetivo: Representar el circuncentro
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,1), C=(2,5);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Los puntos medios
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;
pair MBC=(B+C)/2;

// Las mediatrices
pair U1=MAB+0.4*Perpendicular(A,B);
pair U2=MAB-0.1*Perpendicular(A,B);
draw(U1 -- U2, 1bp+blue);
pair V1=MAC+0.1*Perpendicular(A,C);
pair V2=MAC-0.7*Perpendicular(A,C);
draw(V1 -- V2, 1bp+blue);
pair W1=MBC+0.5*Perpendicular(B,C);
pair W2=MBC-0.1*Perpendicular(B,C);
draw(W1 -- W2, 1bp+blue);

// El circuncentro
pair T=intersectionpoint(U1 -- U2, V1 -- V2);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(T, 4bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Puntos medios
dot(MAB, 3bp+green);
dot(MAC, 3bp+green);
dot(MBC, 3bp+green);

// Marcamos los ángulos rectos
markrightangle(B, MAB, T, 2mm, gray);
markrightangle(B, MBC, T, 2mm, gray);
markrightangle(C, MAC, T, 2mm, gray);
