//---------------------------------------------------------------
// Fichero:  equilatero.asy
// Objetivo: Representar un triángulo equilátero y sus coincidencias
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Sin() Cos()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(Cos(60),Sin(60));

// Los puntos medios
pair MBC=(B+C)/2;
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;

// Las medianas
draw(A -- MBC, 1bp+blue);
draw(B -- MAC, 1bp+blue);
draw(C -- MAB, 1bp+blue);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("Q", MAB, S, 3bp+black);
dot("R", MAC, NW, 3bp+black);
dot("S", MBC, NE, 3bp+black);

// El baricentro
pair G=intersectionpoint(A -- MBC, B -- MAC);
dot("G", G, 2*S+E, 4bp+deepred);

// El triangulo
draw(A -- B -- C -- cycle);

// Marcamos los ángulos rectos
markrightangle(G, MAB, A, 2mm, gray);
markrightangle(G, MBC, B, 2mm, gray);
markrightangle(G, MAC, C, 2mm, gray);
