//---------------------------------------------------------------
// Fichero:  propiedad.asy
// Objetivo: Representar las tres mediatrices
// Fecha:    L.3.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,1), C=(4,4);

// Los puntos medios
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;
pair MBC=(B+C)/2;

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    {
    real Abscisa = ypart(A)-ypart(B);
    real Ordenada = xpart(B)-xpart(A);
    return (Abscisa,Ordenada);
    }

// Las mediatrices
pair U1=MAB+0.5*Perpendicular(A,B);
pair U2=MAB-0.1*Perpendicular(A,B);
draw(U1 -- U2, 0.75bp+blue);
label("$u$", U1, N);
pair V1=MAC+0.2*Perpendicular(A,C);
pair V2=MAC-0.4*Perpendicular(A,C);
draw(V1 -- V2, 0.75bp+blue);
label("$v$", V1, NW);
pair W1=MBC+0.9*Perpendicular(B,C);
pair W2=MBC-0.3*Perpendicular(B,C);
draw(W1 -- W2, 0.75bp+blue);
label("$w$", W2, NW);

// El circuncentro
pair T=intersectionpoint(U1 -- U2, V1 -- V2);

// Los segmentos del circuncentro a los vértices
draw(T -- A, 0.75bp+deepred);
draw(T -- B, 0.75bp+deepred);
draw(T -- C, 0.75bp+deepred);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot(Label("T", fontsize(8pt)+deepred), T, 2.3*S+W, 3bp+deepred);
dot(MAB, 3bp+black);
dot(MAC, 3bp+black);
dot(MBC, 3bp+black);
