//---------------------------------------------------------------
// Fichero:  ortocentro.asy
// Objetivo: Representar el ortocentro
// Fecha:    S.1.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(1,2), B=(0,0), C=(3,0);

// Los puntos proyección
pair Q1=(1,0);
pair Q2=intersectionpoint(A -- C, B -- B+(3,3));
pair Q3=intersectionpoint(A -- B, C -- C+(-4,2));

// Marcamos los ángulos rectos
markrightangle(C, Q1, B, 4mm, gray);

// Las alturas
draw(A -- Q1, 1.5bp+black);
draw(B -- Q2, 1.5bp+black);
draw(C -- Q3, 1.5bp+black);

// El ortocentro
pair H=intersectionpoint(A -- Q1, B -- Q2);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, NW, 3bp+black);
dot("B", B, W, 3bp+black);
dot("C", C, E, 3bp+black);
dot(Q1, 3bp+black);
dot(Q2, 3bp+black);
dot(Q3, 3bp+black);
dot("H", H, 0.4*N+2*E, 4bp+blue);
