//---------------------------------------------------------------
// Fichero:  baricentro.asy
// Objetivo: Representar el baricentro
// Fecha:    D.2.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(3.5,0.5), C=(1,2);

// Los puntos medios
pair MBC=(B+C)/2;
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;

// Las medianas
draw(A -- MBC);
draw(B -- MAC);
draw(C -- MAB);

// El baricentro
pair G=intersectionpoint(A -- MBC, B -- MAC);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot(MAB, 2.5bp+black);
dot(MBC, 2.5bp+black);
dot(MAC, 2.5bp+black);
dot("G", G, 1.5*NNE, 4bp+blue);
