//---------------------------------------------------------------
// Fichero:  demostracion.asy
// Objetivo: Demostrar la suma de ángulos de un triangulo
// Fecha:    J.29.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,0), C=(2,3);

// Puntos auxiliares
pair P=(9,0), Q=B+(C-A);

// El triangulo
draw(A -- B -- C -- cycle);

// Las líneas auxiliares
draw(Q -- B -- P);

// Los vértices
dot("A", A, W, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, N, 3bp+black);

// La semirrecta
label("$r$", Q, NW);

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng), radius=7mm, B, A, C, FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng), radius=11mm, C, B, A, FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng), radius=7mm, A, C, B, FormArc);
markangle(Label("$\alpha$",FormAng), radius=7mm, P, B, Q, FormArc);
markangle(Label("$\gamma$",FormAng), radius=9mm, Q, B, C, FormArc);
