//---------------------------------------------------------------
// Fichero:  degenerado.asy
// Objetivo: Representar un triangulo degenerado
// Fecha:    X.28.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,0), C=(4,0);

// El triangulo
draw(A -- B);

// Los vértices
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, 2*N, 3bp+black);

// Los lados
real Separacion = 0.3;
draw((0,-Separacion) -- (7,-Separacion), blue, Arrows(HookHead,2bp));
draw((Separacion,Separacion) -- (4-Separacion,Separacion),
      blue, Arrows(HookHead,2bp));
draw((4+Separacion,Separacion) -- (7-Separacion,Separacion),
      blue, Arrows(HookHead,2bp));
label("a", (B+C)/2, 2*N);
label("b", (A+C)/2, 2*N);
label("c", (A+B)/2, 2*S);
