//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Mostrar un enunciado
// Fecha:    L.10.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
transform r=rotate(-120);
pair A=(0,0), B=r*(11,0), C=r*(43,0), D=r*(11,60);

// El ángulo recto
markrightangle(C, B, D, 4mm, 0.5bp+gray);

// La figura
draw(D -- A -- B -- D -- C -- B);

// Los nombres
label("32", (B+C)/2, W);
label("68", (D+C)/2, S);
label("61", (D+A)/2, NE);
label("$x$", (A+B)/2, NW);

// Un punto de separación
dot(B, 3bp+black);
