//---------------------------------------------------------------
// Fichero:  enunciado6.asy
// Objetivo: Representar el enunciado 6
// Fecha:    V.7.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,1), C=(0,2);

// Baricentro
pair G=(A+B+C)/3;

// Puntos medios
pair MAB=(A+B)/2;
pair MBC=(B+C)/2;

// El triangulo
draw(A -- B -- C -- cycle);

// Líneas internas
draw(C -- MAB);
draw(A -- MBC);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("P", MAB, S, 3bp+black);
dot("Q", MBC, N, 3bp+black);
dot("R", G, N, 3bp+black);
