//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Representar el enunciado 2
// Fecha:    V.7.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    {
    P1 = P1 - V; P2 = P2 - V;
    return 1/length(P1)*P1 + 1/length(P2)*P2;
    }

// Función que devuelve el incentro de un triángulo
pair Incentro(pair A, pair B, pair C)
    {
    pair AA = extension(A, A+Bisectriz(B,A,C), B, C);
    pair BB = extension(B, B+Bisectriz(A,B,C), A, C);
    return intersectionpoint(A -- AA, B -- BB);
    }

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Definición de los vértices de la base
pair A=(0,0), B=(1,0);

// El vértice superior
pair P=A+2*PuntoCir(60), Q=B+2*PuntoCir(180-48);
pair C=intersectionpoint(A -- P, B -- Q);

// Incentro
pair I=Incentro(A,B,C);

// Los ángulos
markangle("$\alpha$", radius=4mm, A, I, B, 0.5bp+blue);
markangle("$30^\circ$", radius=8mm, I, A, C, 0.5bp+blue);
markangle("$30^\circ$", radius=5mm, B, A, I, 0.5bp+blue);
markangle("$36^\circ$", radius=11mm, A, C, I, 0.5bp+blue);
markangle("$36^\circ$", radius=9mm, I, C, B, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Partes de las bisectrices
draw(A -- I);
draw(B -- I);
draw(C -- I);
