//---------------------------------------------------------------
// Fichero:  enunciado14.asy
// Objetivo: Representar el enunciado 14
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(2,0), C=(1,1);

// Punto auxiliar
pair D=(1,0.3);

// Los ángulos
markangle("$\alpha$", radius=3mm, C, D, A, 0.5bp+blue);
markangle("$\alpha$", radius=4mm, B, D, C, 0.5bp+blue);
markangle("$17^\circ$", radius=16mm, B, A, D, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Líneas auxiliares
draw(D -- A);
draw(D -- B);
draw(D -- C);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=2, angle=30, size=2mm,
                                    space=1mm, p=blue);
draw(A -- D, Formato);
draw(B -- D, Formato);
