//---------------------------------------------------------------
// Fichero:  enunciado11.asy
// Objetivo: Representar el enunciado 11
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(Cos(60),Sin(60));

// Baricentro
pair G = (A+B+C)/3;

// Los ángulos
markangle("$\alpha$", radius=3mm, B, G, C, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(A -- C, FormExt);
draw(B -- C, FormExt);

marker FormInt = StickIntervalMarker(i=1, n=2, angle=135, size=2.5mm,
                                    space=1mm, p=red);
draw(A -- G, FormInt);
draw(B -- G, FormInt);
draw(C -- G, FormInt);
