//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Representar el enunciado 10
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(10,1), C=(3,6);

// Punto auxiliar
pair D=(5,2);

// El triangulo
draw(A -- B -- C -- cycle);

// Las líneas auxiliares
draw(A -- D);
draw(B -- D);
draw(C -- D);

// Los ángulos
markangle("$15^\circ$", radius=14mm, B, A, D, 0.5bp+blue);
markangle("$28^\circ$", radius=8mm, D, A, C, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, A, D, B, 0.5bp+blue);
markangle("$52^\circ$", radius=8mm, A, C, D, 0.5bp+blue);
markangle("$20^\circ$", radius=12mm, D, C, B, 0.5bp+blue);
markangle("$34^\circ$", radius=10mm, C, B, D, 0.5bp+blue);
