//---------------------------------------------------------------
// Fichero:  enunciado09.asy
// Objetivo: Representar el enunciado 9
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(Cos(60),Sin(60));

// Los ángulos
markangle("$\alpha$", radius=8mm, C, B, A, 0.5bp+blue);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- C, Formato);
draw(B -- A, Formato);
draw(B -- C, Formato);
