//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Representar el enunciado 4
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(3,-1), C=(1,2);

// Punto auxiliar
pair D=(1,0.5);

// Los ángulos
markangle("$\alpha$", radius=6mm, B, A, D, 0.5bp+blue);
markangle("$\alpha$", radius=8mm, D, A, C, 0.5bp+blue);
markangle("$60^\circ$", radius=8mm, A, C, B, 0.5bp+blue);
markangle("$34^\circ$", radius=7mm, C, B, A, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// La línea auxiliar
draw(A -- D);
