//---------------------------------------------------------------
// Fichero:  enunciado06.asy
// Objetivo: Representar el enunciado 6
// Fecha:    D.9.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(0,2);

// El ángulo recto
markrightangle(B, A, C, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("$x$", (A+C)/2, W);
label("77", (A+B)/2, S);
label("85", (B+C)/2, N);
