//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Representar la solución 3
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(4,3);

// Marcamos el ángulo recto
markrightangle(A, B, C, 4mm, gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    { return unit(P1-V) + unit(P2-V); }

// Las bisectrices
pair VR = Bisectriz(A,B,C);
pair R1 = B + 1.4*VR;
pair R2 = B - 0.1*VR;
draw(R1 -- R2, 1bp+deepgreen);
pair VS = Bisectriz(B,A,C);
pair S1 = A + 1.8*VS;
pair S2 = A - 0.1*VS;
draw(S1 -- S2, 1bp+deepgreen);
pair VT = Bisectriz(B,C,A);
pair T1 = C + 1.4*VT;
pair T2 = C - 0.1*VT;
draw(T1 -- T2, 1bp+deepgreen);

// El incentro
pair I=intersectionpoint(R1 -- R2, S1 -- S2);
dot(I, 4bp+deepgreen);
