//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Representar la solución 1
// Fecha:    D.2.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Sin() Cos()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(Cos(60),Sin(60));

// Los puntos medios
pair MBC=(B+C)/2;
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;

// Las medianas
draw(A -- MBC, 1bp+deepgreen);
draw(B -- MAC, 1bp+deepgreen);
draw(C -- MAB, 1bp+deepgreen);

// El baricentro
pair G=intersectionpoint(A -- MBC, B -- MAC);
dot(G, 4bp+deepgreen);

// El triangulo
draw(A -- B -- C -- cycle);
