//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Mostrar el enunciado 4
// Fecha:    D.2.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 6, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Definición de los vértices
pair A=(1,1), B=(9,3), C=(5,5);

// Los puntos medios
pair MBC=(B+C)/2;
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;

// Las medianas
draw(A -- MBC, 1bp+deepgreen);
draw(B -- MAC, 1bp+deepgreen);
draw(C -- MAB, 1bp+deepgreen);

// El baricentro
pair G=intersectionpoint(A -- MBC, B -- MAC);
dot(G, 4bp+deepgreen);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(A, 4bp+deepgreen);
dot(B, 4bp+deepgreen);
dot(C, 4bp+deepgreen);
