//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Representar el ejemplo 1
// Fecha:    S.17.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de la recta
pair R1=(0,-4), R2=(0,3);

// Los puntos
pair A1=(-3,2), B1=(-5,0), C1=(-1,-3);

// Los puntos simétricos
pair A2=(3,2), B2=(5,0), C2=(1,-3);

// Las perpendiculares a la recta
pen Punteado = linetype(new real[] {2,2});
draw(A1 -- A2, Punteado+gray);
draw(B1 -- B2, Punteado+gray);
draw(C1 -- C2, Punteado+gray);

// Las figuras
draw(A1 -- B1 -- C1 -- cycle);
draw(A2 -- B2 -- C2 -- cycle);

// Marcamos todos los puntos
dot("A", A1, N, 4bp+black);
dot("B", B1, W, 4bp+black);
dot("C", C1, S, 4bp+black);
dot("A'", A2, N, 4bp+black);
dot("B'", B2, E, 4bp+black);
dot("C'", C2, S, 4bp+black);

// La recta
draw(R1 -- R2);
label("$r$", R2, N);
